@ vim: set ft=armv4 noet:

#define DISPCNT	0x04000000
#define VRAMBG0	0x06000000
#define LCD_W	240
#define LCD_H	160

.arch armv4
.cpu  arm7tdmi

.section .text.crt0,"x"

.arm
.globl _start
_start:
	b .Lrom_hdr_mid @ turns out this one *NEEDS* to be a branch >__>

.globl rom_hdr
rom_hdr:
	@!logo
	.fill 156,1,0

.globl logo_end
logo_end:

	@ title, game code
	@.fill 16,1,0
.Lrom_hdr_mid:
	@ load huge constants here -- avoids putting stuff in the constant pool
	mov r6, #DISPCNT
	mov r7, #VRAMBG0
	@ change to thumb, costs 8 bytes
	add r0, pc, #1
	bx r0
.thumb

	@ maker code
	@.byte 0,0
	b .Lrom_hdr_mid2

	@!magic @ can be used to store address for Channel 3 Wave Pattern RAM
.globl rom_magic
rom_magic:
	.byte 0x96
	@ main unit type
	.byte 0
	@ .byte 0,0x04

	@ device type
	@.byte 0
	@ reserved
	@.fill 7,1,0
.Lrom_hdr_mid2:
	ldrh r1, videomode
	str r1, [r6]
	mov r2, #LCD_W
	b rom_hdr_end

	@ sw version, checksum
	.byte 0, 0x00

	@ reserved
	.byte 0,0

.globl mb$_start
mb$_start:
	b .Lrom_hdr_mid

	@ multiboot stuff: boot method, slave number
	.byte 0 @ set by bios, 0->cart 3->mb
	.byte 0 @ set by bios, 0-3

@ const stuff needs to be word-aligned, even though it's only a halfword...
videomode:
	.short 0x0403

.globl rom_hdr_end
rom_hdr_end:
.Lloop_y:
	mov r4, #0
.Lloop_x:
	mov r5, #0
.Lloop_px:

	push {r2-r5}

	mov r0, #0x10
	mov r1, r4

	and r4, r0
	mov r3, r4
	mov r2, #3
	mul r3, r2
	lsr r3, #2
	add r5, r3
	and r5, r0

	eor r4, r5

	mov r0, #0
	cmp r4, #0
	bgt .Lblack
	mvn r0, r0
.Lblack:

	mov r4, r1
	mov r1, #0xF
	and r4, r1
	cmp r4, #0
	bne .Lnormal
	ldrh r0, =(0x10|(0x10<<5)|(0x10<<10))
.Lnormal:

	pop {r2-r5}

	mov r1, r4
	mul r1, r2
	add r1, r5
	lsl r1, #1

	strh r0, [r7, r1]

	add r5, #1
	cmp r5, #LCD_W
	blt .Lloop_px

	add r4, #1
	cmp r4, #LCD_H
	blt .Lloop_x

.Lloop:
	b .Lloop

.pool

